<?php
echo '=== Testing Role Fix ===' . PHP_EOL;

// Simulate the normalizeInput function
function normalizeInput($data)
{
    // Pastikan $data selalu array - validasi ketat
    if (!is_array($data)) {
        if (is_string($data) && !empty($data)) {
            $decoded = json_decode($data, true);
            $data = is_array($decoded) ? $decoded : [];
        } else {
            $data = [];
        }
    }

    // Gunakan isset() untuk akses array yang aman
    $permissions = isset($data['permissions']) ? $data['permissions'] : [];

    // Handle permissions yang berupa string JSON
    if (is_string($permissions) && !empty($permissions)) {
        $decoded = json_decode($permissions, true);
        $permissions = is_array($decoded) ? $decoded : [];
    } elseif (!is_array($permissions)) {
        $permissions = [];
    }

    // Pastikan permissions selalu array
    $data['permissions'] = array_values((array)$permissions);

    return $data;
}

// Test cases untuk memastikan fix bekerja
$testCases = [
    ['name' => 'Valid Role', 'permissions' => ['read', 'write']],
    'invalid_string_data',
    null,
    ['name' => 'Role with JSON permissions', 'permissions' => '["read","write"]'],
    ['name' => 'Empty permissions', 'permissions' => []],
    ['name' => 'Role with invalid permissions', 'permissions' => 'invalid_json'],
];

foreach ($testCases as $i => $testData) {
    echo "Test case " . ($i + 1) . ": ";
    try {
        $result = normalizeInput($testData);
        echo "✓ Success\n";
        echo "  Name: " . ($result['name'] ?? 'N/A') . "\n";
        echo "  Permissions: " . json_encode($result['permissions']) . "\n";
    } catch (Throwable $e) {
        echo "✗ Error: " . $e->getMessage() . "\n";
    }
    echo "\n";
}

echo '=== Testing array access safety ===' . PHP_EOL;

// Test the problematic scenario
$corruptedData = 'corrupted_string';
echo 'Testing corrupted data: ' . var_export($corruptedData, true) . PHP_EOL;

try {
    // This would cause the original error
    $permissions = $corruptedData['permissions'];
    echo 'Direct access worked (unexpected)' . PHP_EOL;
} catch (Throwable $e) {
    echo 'Direct access failed as expected: ' . $e->getMessage() . PHP_EOL;
}

try {
    // Safe access
    $permissions = isset($corruptedData['permissions']) ? $corruptedData['permissions'] : [];
    echo 'Safe access worked: ' . json_encode($permissions) . PHP_EOL;
} catch (Throwable $e) {
    echo 'Safe access failed: ' . $e->getMessage() . PHP_EOL;
}

echo PHP_EOL . '=== All tests completed ===' . PHP_EOL;
