<?php
echo '=== Testing normalizeInput function ===' . PHP_EOL;

// Simulate the normalizeInput function
function normalizeInput($data)
{
    // Ensure $data is an array
    if (!is_array($data)) {
        if (is_string($data)) {
            $data = json_decode($data, true) ?? [];
        } else {
            $data = [];
        }
    }

    // Additional validation: ensure $data is array after processing
    if (!is_array($data)) {
        error_log('normalizeInput received non-array data: ' . print_r($data, true));
        $data = [];
    }

    $permissions = isset($data['permissions']) ? $data['permissions'] : [];
    if (is_string($permissions)) {
        $decoded = json_decode($permissions, true);
        $permissions = is_array($decoded) ? $decoded : [];
    }

    // ✅ Pastikan tersimpan sebagai array di database
    $data['permissions'] = array_values((array)$permissions);

    return $data;
}

// Test 1: Valid array input
echo 'Test 1: Valid array input' . PHP_EOL;
$testData1 = ['name' => 'Test Role', 'permissions' => ['read', 'write']];
$result1 = normalizeInput($testData1);
var_dump($result1);
echo PHP_EOL;

// Test 2: String input (simulating corrupted data)
echo 'Test 2: String input (corrupted)' . PHP_EOL;
$testData2 = 'invalid_string_data';
try {
    $result2 = normalizeInput($testData2);
    var_dump($result2);
} catch (Throwable $e) {
    echo 'Error: ' . $e->getMessage() . PHP_EOL;
}
echo PHP_EOL;

// Test 3: Null input
echo 'Test 3: Null input' . PHP_EOL;
$testData3 = null;
$result3 = normalizeInput($testData3);
var_dump($result3);
echo PHP_EOL;

// Test 4: Array with string permissions
echo 'Test 4: Array with string permissions' . PHP_EOL;
$testData4 = ['name' => 'Test Role', 'permissions' => '["read","write"]'];
$result4 = normalizeInput($testData4);
var_dump($result4);
echo PHP_EOL;
