<?php
echo '=== Testing potential error scenario ===' . PHP_EOL;

// Simulate the problematic scenario
$data = 'corrupted_data_from_request';
echo 'Original data type: ' . gettype($data) . PHP_EOL;
echo 'Original data value: ' . var_export($data, true) . PHP_EOL;

// This would cause the error if we try to access array offset
try {
    $permissions = $data['permissions']; // This line causes the error
    echo 'No error occurred' . PHP_EOL;
} catch (Throwable $e) {
    echo 'Error caught: ' . $e->getMessage() . PHP_EOL;
}

echo PHP_EOL . '=== Testing with isset ===' . PHP_EOL;

// Safe way using isset
try {
    $permissions = isset($data['permissions']) ? $data['permissions'] : [];
    echo 'Safe access worked, permissions: ' . var_export($permissions, true) . PHP_EOL;
} catch (Throwable $e) {
    echo 'Error caught: ' . $e->getMessage() . PHP_EOL;
}
