<?= $this->extend('layout') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <h1 class="mb-4">Edit User</h1>

    <?php if (isset($validation)): ?>
        <div class="alert alert-danger">
            <?= $validation->listErrors() ?>
        </div>
    <?php endif; ?>

    <form action="/users/update/<?= $user['id'] ?>" method="post">
        <?= csrf_field() ?>
        <div class="form-group">
            <label>Name</label>
            <input type="text" name="name" value="<?= set_value('name', $user['name']) ?>" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Email</label>
            <input type="email" name="email" value="<?= set_value('email', $user['email']) ?>" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Role</label>
            <select name="role_id" class="form-control" required>
                <?php foreach ($roles as $role): ?>
                    <option value="<?= esc($role['id']) ?>"
                        <?= set_value('role_id', $user['role_id'] ?? '') == $role['id'] ? 'selected' : '' ?>>
                        <?= esc(ucfirst($role['name'])) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group">
            <label>New Password <small class="text-muted">(leave blank if not changing)</small></label>
            <input type="password" name="password" class="form-control" minlength="6">
        </div>

        <button type="submit" class="btn btn-primary">Update User</button>
        <a href="/users" class="btn btn-secondary">Back</a>
    </form>
</div>
<?= $this->endSection() ?>