<?= $this->extend('layout') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <h1 class="mb-4">Create New User</h1>

    <?php if (isset($validation)): ?>
        <div class="alert alert-danger">
            <?= $validation->listErrors() ?>
        </div>
    <?php endif; ?>

    <form action="/users/store" method="post">
        <?= csrf_field() ?>
        <div class="form-group">
            <label>Name</label>
            <input type="text" name="name" value="<?= set_value('name') ?>" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Email</label>
            <input type="email" name="email" value="<?= set_value('email') ?>" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Role</label>
            <select name="role" class="form-control" required>
                <?php foreach ($roles as $role): ?>
                    <option value="<?= esc($role['id']) ?>" <?= set_value('role') == $role['id'] ? 'selected' : '' ?>>
                        <?= esc(ucfirst($role['name'])) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group">
            <label>Password</label>
            <input type="password" name="password" class="form-control" required minlength="6">
        </div>

        <button type="submit" class="btn btn-success">Create User</button>
        <a href="/users" class="btn btn-secondary">Back</a>
    </form>
</div>
<?= $this->endSection() ?>