<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <h1 class="mb-4">Data Unit Kerja</h1>

    <div class="d-flex flex-wrap gap-2 mb-3">
        <a href="<?= base_url('/unit_kerja/create') ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Tambah Data
        </a>
        <a href="<?= base_url('/unit_kerja/export') ?>" class="btn btn-success">
            <i class="fas fa-file-excel"></i> Export Excel
        </a>
        <a href="<?= base_url('/unit_kerja/template') ?>" class="btn btn-outline-secondary">
            <i class="fas fa-file-download"></i> Download Template
        </a>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Data Unit Kerja</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="dataTable" class="table table-bordered table-striped" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID Unit Kerja</th>
                            <th>Nama Unit</th>
                            <th>Dosen</th>
                            <th>Created By</th>
                            <th>Updated By</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($items)) : ?>
                            <?php foreach ($items as $item) : ?>
                                <tr>
                                    <td><?= esc($item['id_unit_kerja']) ?></td>
                                    <td><?= esc($item['nama_unit']) ?></td>
                                    <td><?= esc($item['nama_lengkap'] ?? '-') ?></td>
                                    <td><?= esc($item['created_by']) ?></td>
                                    <td><?= esc($item['updated_by']) ?></td>
                                    <td>
                                        <div class="d-flex gap-1">
                                            <a href="<?= base_url('/unit_kerja/show/' . $item['id_unit_kerja']) ?>"
                                                class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?= base_url('/unit_kerja/edit/' . $item['id_unit_kerja']) ?>"
                                                class="btn btn-warning btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="<?= base_url('/unit_kerja/delete/' . $item['id_unit_kerja']) ?>"
                                                method="post"
                                                class="d-inline form-delete">
                                                <?= csrf_field() ?>
                                                <button type="submit"
                                                    class="btn btn-danger btn-sm btn-delete"
                                                    data-name="<?= esc($item['nama_unit']) ?>">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach ?>
                        <?php endif ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {

        $('#dataTable').DataTable();

        <?php if (session()->getFlashdata('success')) : ?>
            Swal.fire({
                icon: 'success',
                title: 'Berhasil',
                text: '<?= session()->getFlashdata('success') ?>',
                timer: 2500,
                showConfirmButton: false
            });
        <?php endif ?>

        <?php if (session()->getFlashdata('error')) : ?>
            Swal.fire({
                icon: 'error',
                title: 'Gagal',
                text: '<?= session()->getFlashdata('error') ?>'
            });
        <?php endif ?>

        document.querySelectorAll('.btn-delete').forEach(btn => {
            btn.addEventListener('click', function(e) {
                e.preventDefault();
                const form = this.closest('form');
                const name = this.dataset.name;

                Swal.fire({
                    title: 'Hapus Data?',
                    text: `Unit kerja "${name}" akan dihapus permanen.`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'Ya, Hapus',
                    cancelButtonText: 'Batal'
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            });
        });
    });
</script>
<?= $this->endSection() ?>