<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Edit Unit Kerja</h4>
        </div>

        <div class="card-body">
            <form action="<?= base_url('/unit_kerja/update/' . $item['id_unit_kerja']) ?>" method="post">
                <?= csrf_field() ?>

                <!-- Nama Unit -->
                <div class="mb-3">
                    <label class="form-label">Nama Unit</label>
                    <input type="text"
                        class="form-control"
                        name="nama_unit"
                        value="<?= old('nama_unit', $item['nama_unit']) ?>"
                        required>
                </div>

                <!-- Penanggung Jawab (Dosen) -->
                <div class="mb-3">
                    <label class="form-label">Penanggung Jawab (Dosen)</label>
                    <select name="id_dosen" class="form-control" required>
                        <option value="">-- Pilih Dosen --</option>
                        <?php foreach ($dosen as $d): ?>
                            <option value="<?= $d['id_dosen'] ?>"
                                <?= $d['id_dosen'] == $item['id_dosen'] ? 'selected' : '' ?>>
                                <?= $d['nama_lengkap'] ?> (<?= $d['nidn'] ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>


                <button type="submit" class="btn btn-warning">
                    <i class="fas fa-save"></i> Update
                </button>
                <a href="<?= base_url('/unit_kerja') ?>" class="btn btn-secondary">
                    Batal
                </a>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>