<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Edit Tindakan Koreksi</h4>
        </div>

        <div class="card-body">
            <form action="<?= base_url('/tindakan_koreksi/update/' . $item['id_koreksi']) ?>" method="post">
                <?= csrf_field() ?>
                <input type="hidden" name="_method" value="PUT">

                <!-- TEMUAN AUDIT -->
                <div class="mb-3">
                    <label class="form-label">Temuan Audit</label>
                    <select name="id_temuan" class="form-control" required>
                        <option value="">-- Pilih Temuan --</option>
                        <?php foreach ($temuan as $t): ?>
                            <option value="<?= $t['id_temuan'] ?>"
                                <?= $item['id_temuan'] == $t['id_temuan'] ? 'selected' : '' ?>>
                                <?= $t['temuan_audit'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <!-- URAIAN -->
                <div class="mb-3">
                    <label class="form-label">Uraian Tindakan</label>
                    <textarea name="uraian_tindakan" class="form-control" required><?= esc($item['uraian_tindakan']) ?></textarea>
                </div>

                <!-- PJ -->
                <div class="mb-3">
                    <label class="form-label">Penanggung Jawab</label>
                    <input type="text" name="penanggung_jawab" class="form-control"
                        value="<?= esc($item['penanggung_jawab']) ?>" required>
                </div>

                <!-- TGL RENCANA -->
                <div class="mb-3">
                    <label class="form-label">Tanggal Rencana</label>
                    <input type="date" name="tgl_rencana" class="form-control"
                        value="<?= $item['tgl_rencana'] ?>">
                </div>

                <!-- TGL REALISASI -->
                <div class="mb-3">
                    <label class="form-label">Tanggal Realisasi</label>
                    <input type="date" name="tgl_realisasi" class="form-control"
                        value="<?= $item['tgl_realisasi'] ?>">
                </div>

                <!-- STATUS -->
                <div class="mb-3">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-control" required>
                        <option value="diajukan" <?= $item['status'] == 'diajukan' ? 'selected' : '' ?>>Diajukan</option>
                        <option value="diproses" <?= $item['status'] == 'diproses' ? 'selected' : '' ?>>Diproses</option>
                        <option value="selesai" <?= $item['status'] == 'selesai' ? 'selected' : '' ?>>Selesai</option>
                    </select>
                </div>

                <button class="btn btn-warning">Update</button>
                <a href="<?= base_url('/tindakan_koreksi') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>