<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Tambah Tindakan Koreksi</h4>
        </div>
        <div class="card-body">
            <form action="<?= base_url('/tindakan_koreksi/store') ?>" method="post">
                <?= csrf_field() ?>

                <div class="mb-3">
                    <label class="form-label">Temuan Audit</label>
                    <select name="id_temuan" class="form-control" required>
                        <option value="">-- Pilih Temuan --</option>
                        <?php foreach ($temuan as $t): ?>
                            <option value="<?= $t['id_temuan'] ?>">
                                <?= $t['temuan_audit'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">Uraian Tindakan</label>
                    <textarea name="uraian_tindakan" class="form-control" required></textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">Penanggung Jawab</label>
                    <input type="text" name="penanggung_jawab" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Tanggal Rencana</label>
                    <input type="date" name="tgl_rencana" class="form-control">
                </div>

                <div class="mb-3">
                    <label class="form-label">Tanggal Realisasi</label>
                    <input type="date" name="tgl_realisasi" class="form-control">
                </div>

                <div class="mb-3">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-control" required>
                        <option value="diajukan">Diajukan</option>
                        <option value="diproses">Diproses</option>
                        <option value="selesai">Selesai</option>
                    </select>
                </div>

                <button class="btn btn-primary">Simpan</button>
                <a href="<?= base_url('/tindakan_koreksi') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>