<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Tambah Temuan Audit</h4>
        </div>

        <div class="card-body">
            <form action="<?= base_url('/temuan_audit/store') ?>" method="post">
                <?= csrf_field() ?>

                <!-- PENUGASAN AUDIT -->
                <div class="mb-3">
                    <label class="form-label">Penugasan Audit</label>
                    <select name="id_penugasan" class="form-control" required>
                        <option value="">-- Pilih Penugasan --</option>
                        <?php foreach ($penugasan as $p): ?>
                            <option value="<?= $p['id_penugasan'] ?>">
                                <?= esc($p['id_penugasan']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- HASIL TEMUAN -->
                <div class="mb-3">
                    <label class="form-label">Hasil Temuan</label>
                    <textarea name="hasil_temuan" class="form-control" rows="3" required>
                        <?= old('hasil_temuan') ?>
                    </textarea>
                </div>

                <!-- TEMUAN AUDIT -->
                <div class="mb-3">
                    <label class="form-label">Temuan Audit</label>
                    <textarea name="temuan_audit" class="form-control" rows="4" required>
                        <?= old('temuan_audit') ?>
                    </textarea>
                </div>

                <div class="mt-4">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="<?= base_url('/temuan_audit') ?>" class="btn btn-secondary">Batal</a>
                </div>

            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>