<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <h1 class="mb-4">Data System_config</h1>
    <a href="<?= base_url('/system_config/create') ?>" class="btn btn-primary mb-3">
        <i class="fas fa-plus"></i> Tambah System_config
    </a>

    <table id="dataTable" class="table table-bordered table-striped">
        <thead><tr><th class="text-capitalize">nama_sistem</th>
<th class="text-capitalize">deskripsi</th>
<th class="text-capitalize">versi</th>
<th class="text-capitalize">logo</th>
<th>Aksi</th></tr></thead>
        <tbody>
        <?php foreach ($items as $item): ?>
        <tr>
            <td><?= esc($item['nama_sistem']) ?></td>
<td><?= esc($item['deskripsi']) ?></td>
<td><?= esc($item['versi']) ?></td>
<td><?= esc($item['logo']) ?></td>

            <td>
                <a href="<?= base_url('/system_config/show/' . $item['id']) ?>" class="btn btn-info btn-sm">Lihat</a>
                <a href="<?= base_url('/system_config/edit/' . $item['id']) ?>" class="btn btn-warning btn-sm">Edit</a>
                <form action="<?= base_url('/system_config/delete/' . $item['id']) ?>" method="post" class="d-inline form-delete">
                    <?= csrf_field() ?>
                    <button type="submit" class="btn btn-danger btn-sm btn-delete" data-name="<?= esc($item['id']) ?>">Hapus</button>
                </form>
            </td>
        </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<?php if (session()->getFlashdata('success')): ?>
<script>
Swal.fire({
    icon: 'success',
    title: 'Berhasil',
    text: '<?= session()->getFlashdata('success') ?>',
    showConfirmButton: false,
    timer: 2000
});
</script>
<?php elseif (session()->getFlashdata('error')): ?>
<script>
Swal.fire({
    icon: 'error',
    title: 'Gagal',
    text: '<?= session()->getFlashdata('error') ?>',
    showConfirmButton: false,
    timer: 2000
});
</script>
<?php endif; ?>

<script>
document.addEventListener('DOMContentLoaded', function () {
    $('#dataTable').DataTable();

    document.querySelectorAll('.btn-delete').forEach(button => {
        button.addEventListener('click', function (e) {
            e.preventDefault();
            const form = this.closest('form');
            const name = this.getAttribute('data-name');
            Swal.fire({
                title: 'Yakin ingin menghapus?',
                text: `Data "${name}" akan dihapus permanen!`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
});
</script>
<?= $this->endSection() ?>