<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Tambah Standar Lembaga Akreditasi</h4>
        </div>

        <div class="card-body">
            <form action="<?= base_url('standar_lembaga_akreditasi/store') ?>" method="post">
                <?= csrf_field() ?>

                <div class="mb-3">
                    <label class="form-label">Lembaga Akreditasi</label>
                    <select name="id_lemb" class="form-control" required>
                        <option value="">-- Pilih Lembaga --</option>
                        <?php foreach ($lembaga as $l): ?>
                            <option value="<?= $l['id_lemb'] ?>">
                                <?= $l['nama_lembaga'] ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">Kode Standar</label>
                    <input type="text" name="kode_standar" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Nama Standar</label>
                    <input type="text" name="nama_standar" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Deskripsi</label>
                    <textarea name="deskripsi" class="form-control" rows="3"></textarea>
                </div>

                <button type="submit" class="btn btn-primary">Simpan</button>
                <a href="<?= base_url('/standar_lembaga_akreditasi') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>