<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Edit Role</h4>
        </div>
        <div class="card-body">
            <form action="<?= base_url('/roles/update/' . $item['id']) ?>" method="post">
                <?= csrf_field() ?>
                <input type="hidden" name="_method" value="PUT">

                <div class="mb-3">
                    <label class="form-label">Nama Role</label>
                    <input type="text" name="name" class="form-control"
                        value="<?= esc(old('name', $item['name'] ?? '')) ?>" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Deskripsi</label>
                    <input type="text" name="description" class="form-control"
                        value="<?= esc(old('description', $item['description'] ?? '')) ?>" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Permissions</label>
                    <div class="row">
                        <?php
                        $allPermissions = get_all_permissions();

                        // Ambil data lama (old input) atau dari database
                        $rawPermissions = old('permissions') ?? $item['permissions'] ?? [];

                        if (is_string($rawPermissions)) {
                            $decoded = json_decode($rawPermissions, true);
                            $selectedPermissions = is_array($decoded) ? $decoded : [];
                        } else {
                            $selectedPermissions = (array) $rawPermissions;
                        }
                        ?>

                        <?php foreach ($allPermissions as $permission): ?>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input type="checkbox"
                                        class="form-check-input"
                                        name="permissions[]"
                                        id="perm_<?= $permission ?>"
                                        value="<?= $permission ?>"
                                        <?= in_array($permission, $selectedPermissions) ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="perm_<?= $permission ?>">
                                        <?= ucwords(str_replace('_', ' ', $permission)) ?>
                                    </label>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <button class="btn btn-warning" type="submit">Update</button>
                <a href="<?= base_url('/roles') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>