<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Tambah Role</h4>
        </div>
        <div class="card-body">
            <form action="<?= base_url('/roles/store') ?>" method="post" id="roleForm">
                <?= csrf_field() ?>

                <div class="mb-3">
                    <label for="name" class="form-label">Nama Role</label>
                    <input type="text" class="form-control" id="name" name="name"
                        value="<?= old('name') ?>" required>
                </div>

                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi</label>
                    <input type="text" class="form-control" id="description" name="description"
                        value="<?= old('description') ?>" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Permissions</label>
                    <div class="row">
                        <?php
                        $allPermissions = get_all_permissions();
                        $selectedPermissions = old('permissions', []);
                        if (is_string($selectedPermissions)) {
                            $decoded = json_decode($selectedPermissions, true);
                            $selectedPermissions = is_array($decoded) ? $decoded : [];
                        }
                        ?>

                        <?php foreach ($allPermissions as $permission): ?>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox"
                                        name="permissions[]"
                                        id="perm_<?= $permission ?>"
                                        value="<?= $permission ?>"
                                        <?= in_array($permission, $selectedPermissions) ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="perm_<?= $permission ?>">
                                        <?= ucwords(str_replace('_', ' ', $permission)) ?>
                                    </label>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary">Simpan</button>
                <a href="<?= base_url('/roles') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('roleForm');
        if (form) {
            form.addEventListener('submit', function(e) {
                const permissions = document.querySelectorAll('input[name="permissions[]"]:checked');
                if (permissions.length === 0) {
                    e.preventDefault();
                    alert('Pilih setidaknya satu permission');
                    return false;
                }

                // Pastikan form data dalam format yang benar
                console.log('Form data:', new FormData(this));
            });
        }
    });
</script>
<?= $this->endSection() ?>