<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <h1 class="mb-4">Profil Pengguna</h1>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Profil</h6>
                </div>
                <div class="card-body">
                    <form action="<?= base_url('/profile/update') ?>" method="post">
                        <?= csrf_field() ?>

                        <div class="form-group">
                            <label for="name">Nama Lengkap</label>
                            <input type="text" class="form-control" id="name" name="name"
                                value="<?= old('name', $user['name'] ?? '') ?>" required>
                            <?php if (isset($errors['name'])): ?>
                                <div class="text-danger small mt-1"><?= $errors['name'] ?></div>
                            <?php endif; ?>
                        </div>

                        <div class="form-group">
                            <label for="email">Email</label>
                            <input type="email" class="form-control" id="email" name="email"
                                value="<?= old('email', $user['email'] ?? '') ?>" required>
                            <?php if (isset($errors['email'])): ?>
                                <div class="text-danger small mt-1"><?= $errors['email'] ?></div>
                            <?php endif; ?>
                        </div>

                        <div class="form-group">
                            <label for="password">Password Baru (Opsional)</label>
                            <input type="password" class="form-control" id="password" name="password"
                                placeholder="Kosongkan jika tidak ingin mengubah password">
                            <small class="form-text text-muted">Biarkan kosong jika tidak ingin mengubah password</small>
                        </div>

                        <div class="form-group">
                            <label for="password_confirm">Konfirmasi Password Baru</label>
                            <input type="password" class="form-control" id="password_confirm" name="password_confirm"
                                placeholder="Konfirmasi password baru">
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Simpan Perubahan
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Akun</h6>
                </div>
                <div class="card-body">
                    <div class="text-center mb-3">
                        <i class="fas fa-user-circle fa-4x text-primary"></i>
                    </div>
                    <p><strong>Nama:</strong> <?= esc($user['name'] ?? 'N/A') ?></p>
                    <p><strong>Email:</strong> <?= esc($user['email'] ?? 'N/A') ?></p>
                    <p><strong>Role:</strong> <?= esc($user['role_name'] ?? 'N/A') ?></p>
                    <p><strong>Terakhir Login:</strong> <?= esc($user['last_login'] ?? 'N/A') ?></p>
                </div>
            </div>

            <div class="card shadow">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Permissions</h6>
                </div>
                <div class="card-body">
                    <?php
                    $permissions = $user['permissions'] ?? [];
                    if (is_string($permissions)) {
                        $permissions = json_decode($permissions, true) ?? [];
                    }
                    ?>
                    <?php if (!empty($permissions)): ?>
                        <ul class="list-group list-group-flush">
                            <?php foreach ($permissions as $permission): ?>
                                <li class="list-group-item px-0">
                                    <i class="fas fa-check text-success mr-2"></i>
                                    <?= esc($permission) ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else: ?>
                        <p class="text-muted">Tidak ada permissions yang ditetapkan.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Password confirmation validation
        const password = document.getElementById('password');
        const passwordConfirm = document.getElementById('password_confirm');

        function validatePassword() {
            if (password.value !== passwordConfirm.value) {
                passwordConfirm.setCustomValidity('Password tidak cocok');
            } else {
                passwordConfirm.setCustomValidity('');
            }
        }

        password.addEventListener('input', validatePassword);
        passwordConfirm.addEventListener('input', validatePassword);
    });
</script>
<?= $this->endSection() ?>