<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <h1 class="mb-4">Data Prodi</h1>

    <div class="d-flex flex-wrap gap-2 mb-3">
        <a href="<?= base_url('/prodi/create') ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Tambah Data
        </a>
        <a href="<?= base_url('/prodi/export') ?>" class="btn btn-success">
            <i class="fas fa-file-excel"></i> Export Excel
        </a>
        <a href="<?= base_url('/prodi/template') ?>" class="btn btn-outline-secondary">
            <i class="fas fa-file-download"></i> Download Template
        </a>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">Import Data dari Excel</h6>
        </div>
        <div class="card-body">
            <form action="<?= base_url('/prodi/import') ?>" method="post" enctype="multipart/form-data" class="d-flex flex-wrap gap-2 align-items-center">
                <?= csrf_field() ?>
                <div class="flex-grow-1">
                    <input type="file" name="excel_file" id="excel_file" class="form-control" accept=".xlsx,.xls" required>
                </div>
                <button type="submit" class="btn btn-info">
                    <i class="fas fa-file-upload"></i> Upload & Import
                </button>
            </form>
            <small class="form-text text-muted mt-2">
                Gunakan file template yang telah diunduh untuk memastikan format kolom sesuai.
            </small>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Data</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="dataTable" class="table table-bordered table-striped" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th class="text-capitalize">Id Prodi</th>
                            <th class="text-capitalize">Nama Prodi</th>
                            <th class="text-capitalize">Created By</th>
                            <th class="text-capitalize">Updated By</th>
                            <th class="text-capitalize">Id User</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($items)): ?>
                            <?php foreach ($items as $item): ?>
                                <tr>
                                    <td><?= esc($item['id_prodi']) ?></td>
                                    <td><?= esc($item['nama_prodi']) ?></td>
                                    <td><?= esc($item['created_by']) ?></td>
                                    <td><?= esc($item['updated_by']) ?></td>
                                    <td><?= esc($item['id_user']) ?></td>

                                    <td>
                                        <div class="d-flex gap-2">
                                            <a href="<?= base_url('/prodi/show/' . $item['id_prodi']) ?>" class="btn btn-info btn-sm"><i class="fas fa-eye"></i></a>
                                            <a href="<?= base_url('/prodi/edit/' . $item['id_prodi']) ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                                            <form action="<?= base_url('/prodi/delete/' . $item['id_prodi']) ?>" method="post" class="d-inline form-delete">
                                                <?= csrf_field() ?>
                                                <input type="hidden" name="_method" value="post">
                                                <button type="submit" class="btn btn-danger btn-sm btn-delete" data-name="<?= esc($item['id_prodi']) ?>"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Inisialisasi DataTable
        $('#dataTable').DataTable();

        // SweetAlert untuk notifikasi
        <?php if (session()->getFlashdata('success')): ?>
            Swal.fire({
                icon: 'success',
                title: 'Berhasil',
                text: '<?= session()->getFlashdata('success') ?>',
                timer: 2500
            });
        <?php elseif (session()->getFlashdata('error')): ?>
            Swal.fire({
                icon: 'error',
                title: 'Gagal',
                text: '<?= session()->getFlashdata('error') ?>',
                timer: 4000
            });
        <?php endif; ?>

        // SweetAlert untuk konfirmasi hapus
        document.querySelectorAll('.btn-delete').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const form = this.closest('form');
                const name = this.getAttribute('data-name');
                Swal.fire({
                    title: 'Anda Yakin?',
                    text: `Data dengan ID "${name}" akan dihapus secara permanen.`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Ya, Hapus!',
                    cancelButtonText: 'Batal'
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            });
        });
    });
</script>
<?= $this->endSection() ?>