<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Edit Penugasan Audit</h4>
        </div>

        <div class="card-body">
            <form action="<?= base_url('/penugasan_audit/update/' . $item['id_penugasan']) ?>" method="post">
                <?= csrf_field() ?>

                <!-- AUTO -->
                <input type="hidden" name="updated_by" value="<?= session()->get('id_user') ?>">
                <input type="hidden" name="created_by" value="<?= $item['created_by'] ?>">

                <!-- PERIODE (READONLY) -->
                <select name="id_periode" class="form-control" required>
                    <option value="">-- Pilih Tahun Audit --</option>
                    <?php foreach ($periodes as $p): ?>
                        <option value="<?= $p['id_periode']; ?>"
                            <?= ($item['id_periode'] == $p['id_periode']) ? 'selected' : ''; ?>>
                            <?= esc($p['tahun_audit']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>

                <!-- AUDITOR -->
                <div class="mb-3">
                    <label class="form-label fw-bold">Auditor</label>
                    <select name="id_auditor" class="form-control" required>
                        <?php foreach ($auditors as $a): ?>
                            <option value="<?= $a['id_auditor'] ?>"
                                <?= $a['id_auditor'] == $item['id_auditor'] ? 'selected' : '' ?>>
                                <?= esc($a['id_dosen']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <hr>

                <!-- FAKULTAS -->
                <div class="mb-3">
                    <label class="form-label">Fakultas</label>
                    <select name="id_fakultas" class="form-control">
                        <option value="">-- Tidak Dipilih --</option>
                        <?php foreach ($fakultas as $f): ?>
                            <option value="<?= $f['id_fakultas'] ?>"
                                <?= $f['id_fakultas'] == $item['id_fakultas'] ? 'selected' : '' ?>>
                                <?= esc($f['nama_fakultas']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- PRODI -->
                <div class="mb-3">
                    <label class="form-label">Program Studi</label>
                    <select name="id_prodi" class="form-control">
                        <option value="">-- Tidak Dipilih --</option>
                        <?php foreach ($prodi as $p): ?>
                            <option value="<?= $p['id_prodi'] ?>"
                                <?= $p['id_prodi'] == $item['id_prodi'] ? 'selected' : '' ?>>
                                <?= esc($p['nama_prodi']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- UNIT KERJA -->
                <div class="mb-3">
                    <label class="form-label">Unit Kerja</label>
                    <select name="id_unit_kerja" class="form-control">
                        <option value="">-- Tidak Dipilih --</option>

                        <?php foreach ($unit_kerja as $u): ?>
                            <option value="<?= $u['id_unit_kerja']; ?>"
                                <?= ($item['id_unit_kerja'] == $u['id_unit_kerja']) ? 'selected' : ''; ?>>
                                <?= esc($u['nama_unit']); ?>
                            </option>
                        <?php endforeach; ?>

                    </select>
                </div>

                <div class="mt-4">
                    <button type="submit" class="btn btn-primary">
                        Simpan Perubahan
                    </button>
                    <a href="<?= base_url('/penugasan_audit') ?>" class="btn btn-secondary">
                        Batal
                    </a>
                </div>

            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>