<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Tambah Penugasan Audit</h4>
        </div>

        <div class="card-body">
            <form action="<?= base_url('/penugasan_audit/store') ?>" method="post">
                <?= csrf_field() ?>

                <!-- AUTO CREATED / UPDATED -->
                <input type="hidden" name="created_by" value="<?= session()->get('id') ?>">
                <input type="hidden" name="updated_by" value="<?= session()->get('id') ?>">

                <!-- PERIODE AUDIT -->
                <div class="mb-3">
                    <label class="form-label fw-bold">Tahun Audit <span class="text-danger">*</span></label>
                    <select name="id_periode" class="form-control" required>
                        <option value="">-- Pilih Tahun Audit --</option>
                        <?php foreach ($periodes as $p): ?>
                            <option value="<?= $p['id_periode'] ?>">
                                <?= esc($p['tahun_audit']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- AUDITOR -->
                <div class="mb-3">
                    <label class="form-label fw-bold">Auditor (ID Dosen) <span class="text-danger">*</span></label>
                    <select name="id_auditor" class="form-control" required>
                        <option value="">-- Pilih Auditor --</option>
                        <?php foreach ($auditors as $a): ?>
                            <option value="<?= $a['id_auditor'] ?>">
                                <?= esc($a['id_dosen']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <hr>

                <p class="text-muted mb-2">
                    Pilih <strong>salah satu</strong> target audit di bawah (opsional):
                </p>

                <!-- FAKULTAS -->
                <div class="mb-3">
                    <label class="form-label">Fakultas</label>
                    <select name="id_fakultas" class="form-control">
                        <option value="">-- Tidak Dipilih --</option>
                        <?php foreach ($fakultas as $f): ?>
                            <option value="<?= $f['id_fakultas'] ?>">
                                <?= esc($f['nama_fakultas']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- PRODI -->
                <div class="mb-3">
                    <label class="form-label">Program Studi</label>
                    <select name="id_prodi" class="form-control">
                        <option value="">-- Tidak Dipilih --</option>
                        <?php foreach ($prodi as $p): ?>
                            <option value="<?= $p['id_prodi'] ?>">
                                <?= esc($p['nama_prodi']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- UNIT KERJA -->
                <div class="mb-3">
                    <label class="form-label">Unit Kerja</label>
                    <select name="id_unit_kerja" class="form-control">
                        <option value="">-- Tidak Dipilih --</option>
                        <?php foreach ($unit_kerja as $u): ?>
                            <option value="<?= $u['id_unit_kerja'] ?>">
                                <?= esc($u['nama_unit']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="mt-4">
                    <button type="submit" class="btn btn-primary">
                        Simpan
                    </button>
                    <a href="<?= base_url('/penugasan_audit') ?>" class="btn btn-secondary">
                        Batal
                    </a>
                </div>

            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>