<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <h1 class="mb-4">Data Peluang Peningkatan</h1>

    <div class="d-flex flex-wrap gap-2 mb-3">
        <a href="<?= base_url('/peluang_peningkatan/create') ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Tambah Data
        </a>
        <a href="<?= base_url('/peluang_peningkatan/export') ?>" class="btn btn-success">
            <i class="fas fa-file-excel"></i> Export Excel
        </a>
        <a href="<?= base_url('/peluang_peningkatan/template') ?>" class="btn btn-outline-secondary">
            <i class="fas fa-file-download"></i> Download Template
        </a>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Data</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="dataTable" class="table table-bordered table-striped">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Standar</th>
                            <th>Daftar Tilik</th>
                            <th>Fakultas</th>
                            <th>Prodi</th>
                            <th>Unit Kerja</th>
                            <th>Bidang</th>
                            <th>Kelebihan</th>
                            <th>Peluang</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($items)) : ?>
                            <?php foreach ($items as $item) : ?>
                                <tr>
                                    <td><?= esc($item['id_peluang']) ?></td>
                                    <td><?= esc($item['nama_standar'] ?? '-') ?></td>
                                    <td><?= esc($item['nama_tilik'] ?? '-') ?></td>
                                    <td><?= esc($item['nama_fakultas'] ?? '-') ?></td>
                                    <td><?= esc($item['nama_prodi'] ?? '-') ?></td>
                                    <td><?= esc($item['nama_unit'] ?? '-') ?></td>
                                    <td><?= esc($item['bidang']) ?></td>
                                    <td><?= esc($item['kelebihan']) ?></td>
                                    <td><?= esc($item['peluang']) ?></td>
                                    <td>
                                        <div class="d-flex gap-1">
                                            <a href="<?= base_url('/peluang_peningkatan/show/' . $item['id_peluang']) ?>" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?= base_url('/peluang_peningkatan/edit/' . $item['id_peluang']) ?>" class="btn btn-warning btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="<?= base_url('/peluang_peningkatan/delete/' . $item['id_peluang']) ?>" method="post" class="form-delete d-inline">
                                                <?= csrf_field() ?>
                                                <button type="submit" class="btn btn-danger btn-sm btn-delete"
                                                    data-name="<?= esc($item['id_peluang']) ?>">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach ?>
                        <?php endif ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function() {
        $('#dataTable').DataTable();

        <?php if (session()->getFlashdata('success')) : ?>
            Swal.fire({
                icon: 'success',
                title: 'Berhasil',
                text: '<?= session()->getFlashdata('success') ?>',
                timer: 2500,
                showConfirmButton: false
            });
        <?php endif ?>

        document.querySelectorAll('.btn-delete').forEach(btn => {
            btn.addEventListener('click', function(e) {
                e.preventDefault();
                const form = this.closest('form');
                const name = this.dataset.name;

                Swal.fire({
                    title: 'Yakin hapus?',
                    text: `Data ID ${name} akan dihapus permanen`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonText: 'Batal',
                    confirmButtonText: 'Ya, hapus'
                }).then(result => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            });
        });
    });
</script>
<?= $this->endSection() ?>