<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Tambah Peluang Peningkatan</h4>
        </div>
        <div class="card-body">
            <form action="<?= base_url('/peluang_peningkatan/store') ?>" method="post">
                <?= csrf_field() ?>

                <!-- STANDAR -->
                <div class="mb-3">
                    <label class="form-label">Standar Akreditasi</label>
                    <select name="id_standar" class="form-control" required>
                        <option value="">-- Pilih Standar --</option>
                        <?php foreach ($standar as $s): ?>
                            <option value="<?= $s['id_standar'] ?>">
                                <?= $s['nama_standar'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <!-- TILIK -->
                <div class="mb-3">
                    <label class="form-label">Daftar Tilik</label>
                    <select name="id_tilik" class="form-control" required>
                        <option value="">-- Pilih Tilik --</option>
                        <?php foreach ($tilik as $t): ?>
                            <option value="<?= $t['id_tilik'] ?>">
                                <?= $t['pertanyaan'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <!-- OPSIONAL SESUAI KONTEKS -->
                <div class="mb-3">
                    <label class="form-label">Fakultas (Opsional)</label>
                    <select name="id_fakultas" class="form-control">
                        <option value="">-- Semua Fakultas --</option>
                        <?php foreach ($fakultas as $f): ?>
                            <option value="<?= $f['id_fakultas'] ?>"><?= $f['nama_fakultas'] ?></option>
                        <?php endforeach ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">Program Studi (Opsional)</label>
                    <select name="id_prodi" class="form-control">
                        <option value="">-- Semua Prodi --</option>
                        <?php foreach ($prodi as $p): ?>
                            <option value="<?= $p['id_prodi'] ?>"><?= $p['nama_prodi'] ?></option>
                        <?php endforeach ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">Unit Kerja (Opsional)</label>
                    <select name="id_unit_kerja" class="form-control">
                        <option value="">-- Semua Unit --</option>
                        <?php foreach ($unit_kerja as $u): ?>
                            <option value="<?= $u['id_unit_kerja'] ?>">
                                <?= $u['nama_unit'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>


                <!-- DATA UTAMA -->
                <div class="mb-3">
                    <label class="form-label">Bidang</label>
                    <input type="text" name="bidang" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Kelebihan</label>
                    <textarea name="kelebihan" class="form-control" rows="3"></textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">Peluang Peningkatan</label>
                    <textarea name="peluang" class="form-control" rows="3"></textarea>
                </div>

                <button type="submit" class="btn btn-primary">Simpan</button>
                <a href="<?= base_url('/peluang_peningkatan') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>