<?= $this->extend('layout') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <h1 class="mb-4">Menu Management</h1>
    <a href="/menus/create" class="btn btn-primary mb-3"><i class="fas fa-plus"></i> Create New Menu</a>

    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
    <?php endif; ?>

    <table id="menusTable" class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Sort Order</th>
                <th>Title</th>
                <th>URL</th>
                <th>Icon</th>
                <th>Permission</th>
                <th>Parent ID</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($menus)): ?>
                <?php foreach ($menus as $menu): ?>
                    <tr>
                        <td><?= esc($menu['sort_order']) ?></td>
                        <td><?= esc($menu['title']) ?></td>
                        <td><?= esc($menu['url']) ?></td>
                        <td><i class="fas <?= esc($menu['icon']) ?>"></i></td>
                        <td><?= esc($menu['permission']) ?></td>
                        <td><?= esc($menu['parent_id']) ?></td>
                        <td>
                            <a href="/menus/edit/<?= $menu['id'] ?>" class="btn btn-info btn-sm"><i class="fas fa-edit"></i></a>
                            <a href="/menus/delete/<?= $menu['id'] ?>" class="btn btn-danger btn-sm btn-delete" data-id="<?= $menu['id'] ?>"><i class="fas fa-trash"></i></a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
$(document).ready(function () {
    $('#menusTable').DataTable();

    $('.btn-delete').on('click', function(e) {
        e.preventDefault();
        var href = $(this).attr('href');

        Swal.fire({
            title: 'Are you sure?',
            text: "Menu will be deleted permanently!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Delete'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = href;
            }
        });
    });
});
</script>
<?= $this->endSection() ?>
