<?= $this->extend('layout') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <h1 class="mb-4">Create New Menu</h1>

    <?php if (isset($validation)): ?>
        <div class="alert alert-danger">
            <?= $validation->listErrors() ?>
        </div>
    <?php endif; ?>

    <form action="/menus/store" method="post">
        <?= csrf_field() ?>

        <div class="form-group">
            <label for="title">Menu Title</label>
            <input type="text" name="title" id="title" value="<?= set_value('title') ?>" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="url">URL</label>
            <input type="text" name="url" id="url" value="<?= set_value('url') ?>" class="form-control" placeholder="/path or full URL">
        </div>

        <div class="form-group">
            <label for="icon">Icon Class</label>
            <input type="text" name="icon" id="icon" value="<?= set_value('icon', 'fa-circle') ?>" class="form-control" placeholder="e.g. fa-users">
            <small class="form-text text-muted">Use FontAwesome icon classes.</small>
        </div>

        <div class="form-group">
            <label for="parent_id">Parent Menu</label>
            <select name="parent_id" id="parent_id" class="form-control">
                <option value="">-- None --</option>
                <?php foreach($parentMenus as $parent): ?>
                    <option value="<?= $parent['id'] ?>" <?= set_select('parent_id', $parent['id']) ?>><?= esc($parent['title']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group">
            <label for="permission">Required Permissions</label>
            <input type="text" name="permission" id="permission" value="<?= set_value('permission') ?>" class="form-control" placeholder="Comma separated permissions">
            <small class="form-text text-muted">Leave blank if accessible by all users.</small>
        </div>

        <div class="form-group">
            <label for="sort_order">Sort Order</label>
            <input type="number" name="sort_order" id="sort_order" value="<?= set_value('sort_order', 0) ?>" class="form-control" required>
        </div>

        <button type="submit" class="btn btn-success">Create Menu</button>
        <a href="/menus" class="btn btn-secondary">Cancel</a>
    </form>
</div>
<?= $this->endSection() ?>
