<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Edit Matrix Penilaian</h4>
        </div>
        <div class="card-body">
            <form action="<?= base_url('/matrix_penilaian/update/' . $item['id_matrix']) ?>" method="post">
                <?= csrf_field() ?>
                <input type="hidden" name="_method" value="PUT">

                <!-- ID MATRIX (HIDDEN, BUKAN INPUT USER) -->
                <input type="hidden" name="id_matrix" value="<?= $item['id_matrix'] ?>">

                <!-- STANDAR -->
                <div class="mb-3">
                    <label class="form-label">Standar Akreditasi</label>
                    <select name="id_standar" class="form-control" required>
                        <option value="">-- Pilih Standar --</option>
                        <?php foreach ($standar as $s): ?>
                            <option value="<?= $s['id_standar'] ?>"
                                <?= ($s['id_standar'] == $item['id_standar']) ? 'selected' : '' ?>>
                                <?= $s['nama_standar'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <!-- DESKRIPSI -->
                <div class="mb-3">
                    <label class="form-label">Deskripsi Kriteria</label>
                    <textarea name="deskripsi_kriteria" class="form-control" rows="3" required><?= old('deskripsi_kriteria', $item['deskripsi_kriteria']) ?></textarea>
                </div>

                <!-- NILAI -->
                <div class="mb-3">
                    <label class="form-label">Nilai</label>
                    <input type="number" name="nilai" class="form-control"
                        value="<?= old('nilai', $item['nilai']) ?>" required>
                </div>

                <button type="submit" class="btn btn-warning">Update</button>
                <a href="<?= base_url('/matrix_penilaian') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>