<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Tambah Matrix Penilaian</h4>
        </div>

        <div class="card-body">
            <form action="<?= base_url('/matrix_penilaian/store') ?>" method="post">
                <?= csrf_field() ?>

                <!-- Standar -->
                <div class="mb-3">
                    <label class="form-label">Standar Akreditasi</label>
                    <select name="id_standar" class="form-control" required>
                        <option value="">-- Pilih Standar --</option>
                        <?php foreach ($standar as $s): ?>
                            <option value="<?= $s['id_standar'] ?>"
                                <?= old('id_standar') == $s['id_standar'] ? 'selected' : '' ?>>
                                <?= $s['kode_standar'] ?> - <?= $s['nama_standar'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <!-- Deskripsi -->
                <div class="mb-3">
                    <label class="form-label">Deskripsi Kriteria</label>
                    <textarea name="deskripsi_kriteria" class="form-control" rows="3" required><?= old('deskripsi_kriteria') ?></textarea>
                </div>

                <!-- Nilai -->
                <div class="mb-3">
                    <label class="form-label">Nilai</label>
                    <input
                        type="number"
                        name="nilai"
                        class="form-control"
                        value="<?= old('nilai') ?>"
                        step="1"
                        required>
                </div>


                <button type="submit" class="btn btn-primary">Simpan</button>
                <a href="<?= base_url('/matrix_penilaian') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>