<?= $this->extend('layout') ?>

<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Log Aktivitas Detail</h3>
                    <div class="card-tools">
                        <a href="<?= base_url('/log-aktivitas') ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Logs
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="150">ID:</th>
                                    <td><?= $log['id'] ?></td>
                                </tr>
                                <tr>
                                    <th>Action:</th>
                                    <td>
                                        <span class="badge badge-info"><?= ucwords(str_replace('_', ' ', $log['aksi'])) ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>User ID:</th>
                                    <td><?= $log['user_id'] ?></td>
                                </tr>
                                <tr>
                                    <th>Username:</th>
                                    <td><?= $log['username'] ?></td>
                                </tr>
                                <tr>
                                    <th>IP Address:</th>
                                    <td><?= $log['ip_address'] ?: 'N/A' ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="150">Timestamp:</th>
                                    <td><?= date('d M Y H:i:s', strtotime($log['created_at'])) ?></td>
                                </tr>
                                <tr>
                                    <th>URL:</th>
                                    <td>
                                        <small class="text-break"><?= $log['url'] ?: 'N/A' ?></small>
                                    </td>
                                </tr>
                                <tr>
                                    <th>User Agent:</th>
                                    <td>
                                        <small class="text-break"><?= $log['user_agent'] ?: 'N/A' ?></small>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Keterangan :</th>
                                    <td>
                                        <small class="text-break"><?= $log['keterangan'] ?: 'N/A' ?></small>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <?php if (!empty($log['user_agent'])): ?>
                        <div class="row mt-3">
                            <div class="col-12">
                                <h5>User Agent Details:</h5>
                                <pre class="bg-light p-2 rounded"><code><?= $log['user_agent'] ?></code></pre>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>