<?= $this->extend('layout') ?>

<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Log Aktivitas</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filter Form -->
                    <form method="get" action="<?= base_url('/log-aktivitas/filter') ?>" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="action">Action</label>
                                <select name="action" id="action" class="form-control">
                                    <option value="">All Actions</option>
                                    <option value="login" <?= (isset($filters['aksi']) && $filters['aksi'] == 'login') ? 'selected' : '' ?>>Login</option>
                                    <option value="logout" <?= (isset($filters['aksi']) && $filters['aksi'] == 'logout') ? 'selected' : '' ?>>Logout</option>
                                    <option value="create_user" <?= (isset($filters['aksi']) && $filters['aksi'] == 'create_user') ? 'selected' : '' ?>>Create User</option>
                                    <option value="update_user" <?= (isset($filters['aksi']) && $filters['aksi'] == 'update_user') ? 'selected' : '' ?>>Update User</option>
                                    <option value="delete_user" <?= (isset($filters['aksi']) && $filters['aksi'] == 'delete_user') ? 'selected' : '' ?>>Delete User</option>
                                    <option value="create_role" <?= (isset($filters['aksi']) && $filters['aksi'] == 'create_role') ? 'selected' : '' ?>>Create Role</option>
                                    <option value="update_role" <?= (isset($filters['aksi']) && $filters['aksi'] == 'update_role') ? 'selected' : '' ?>>Update Role</option>
                                    <option value="delete_role" <?= (isset($filters['aksi']) && $filters['aksi'] == 'delete_role') ? 'selected' : '' ?>>Delete Role</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="user_id">User ID</label>
                                <input type="text" name="user_id" id="user_id" class="form-control" value="<?= $filters['user_id'] ?? '' ?>" placeholder="Enter User ID">
                            </div>
                            <div class="col-md-3">
                                <label for="date_from">Date From</label>
                                <input type="date" name="date_from" id="date_from" class="form-control" value="<?= $filters['date_from'] ?? '' ?>">
                            </div>
                            <div class="col-md-3">
                                <label for="date_to">Date To</label>
                                <input type="date" name="date_to" id="date_to" class="form-control" value="<?= $filters['date_to'] ?? '' ?>">
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">Filter</button>
                                <a href="<?= base_url('/log-aktivitas') ?>" class="btn btn-secondary">Clear Filters</a>
                            </div>
                        </div>
                    </form>

                    <!-- Logs Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Action</th>
                                    <th>User</th>
                                    <th>Keterangan</th>
                                    <th>IP Address</th>
                                    <th>URL</th>
                                    <th>Timestamp</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($logs)): ?>
                                    <?php foreach ($logs as $log): ?>
                                        <tr>
                                            <td><?= $log['id'] ?></td>
                                            <td>
                                                <span class="badge badge-info"><?= ucwords(str_replace('_', ' ', $log['aksi'])) ?></span>
                                            </td>
                                            <td>
                                                <?= $log['username'] ?> (ID: <?= $log['user_id'] ?>)
                                            </td>
                                            <td>
                                                <?php
                                                if (!empty($log['keterangan'])) {
                                                    confirm:
                                                    $text = strip_tags($log['keterangan']); // buang HTML dulu
                                                    echo strlen($text) > 20
                                                        ? substr($text, 0, 20) . '...Selengkapnya lihat view'
                                                        : $text;
                                                } else {
                                                    echo '-';
                                                }
                                                ?>
                                            </td>
                                            <td><?= $log['ip_address'] ?: 'N/A' ?></td>
                                            <td>
                                                <small><?= $log['url'] ?: 'N/A' ?></small>
                                            </td>
                                            <td><?= date('d M Y H:i:s', strtotime($log['created_at'])) ?></td>
                                            <td>
                                                <a href="<?= base_url('/log-aktivitas/show/' . $log['id']) ?>" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i> View
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="7" class="text-center">No log entries found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <?php if ($totalPages > 1): ?>
                        <nav aria-label="Log pagination">
                            <ul class="pagination justify-content-center">
                                <?php if ($currentPage > 1): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?= $currentPage - 1 ?><?= isset($filters) ? '&' . http_build_query($filters) : '' ?>">Previous</a>
                                    </li>
                                <?php endif; ?>

                                <?php for ($i = max(1, $currentPage - 2); $i <= min($totalPages, $currentPage + 2); $i++): ?>
                                    <li class="page-item <?= $i == $currentPage ? 'active' : '' ?>">
                                        <a class="page-link" href="?page=<?= $i ?><?= isset($filters) ? '&' . http_build_query($filters) : '' ?>"><?= $i ?></a>
                                    </li>
                                <?php endfor; ?>

                                <?php if ($currentPage < $totalPages): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?= $currentPage + 1 ?><?= isset($filters) ? '&' . http_build_query($filters) : '' ?>">Next</a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>