<?php
helper('permission');
$userPermissions = get_user_permissions();
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title><?= $title ?? 'AUDIT' ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- AdminLTE CSS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.1/dist/css/adminlte.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <!-- DataTables CSS -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap4.min.css">
  <!-- SweetAlert2 CSS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

  <style>
    /* additional custom styles can go here */
  </style>
  <?= $this->renderSection('styles') ?>
</head>

<body class="hold-transition sidebar-mini">
  <div class="wrapper">

    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
      <!-- Left navbar links -->
      <ul class="navbar-nav">
        <li class="nav-item">
          <a href="#" class="nav-link" data-widget="pushmenu"><i class="fas fa-bars"></i></a>
        </li>
        <li class="nav-item d-none d-sm-inline-block">
          <a href="/dashboard" class="nav-link">Home</a>
        </li>
      </ul>

      <!-- Right navbar links -->
      <ul class="navbar-nav ml-auto">
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="fas fa-user"></i> <?= session()->get('name') ?? 'User' ?>
          </a>
          <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
            <a class="dropdown-item" href="/profile">
              <i class="fas fa-user-circle"></i> Profil
            </a>
            <div class="dropdown-divider"></div>
            <a class="dropdown-item" href="/logout">
              <i class="fas fa-sign-out-alt"></i> Logout
            </a>
          </div>
        </li>
      </ul>
    </nav>
    <!-- /.navbar -->

    <!-- Main Sidebar Container -->
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
      <!-- Brand Logo -->
      <a href="/dashboard" class="brand-link">
        <span class="brand-text font-weight-light">AUDIT TERPADU</span>
      </a>

      <!-- Sidebar -->
      <div class="sidebar">

        <!-- Sidebar Menu -->
        <nav class="mt-2">
          <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
            <?php
            function renderMenuItems(array $menus)
            {
              foreach ($menus as $menu) {
                $hasChildren = !empty($menu['children']);
                $url = esc($menu['url'] ?? '#');
                $icon = esc($menu['icon'] ?? 'fas fa-circle');
                $title = esc($menu['title'] ?? '');
                $active = current_url() === site_url($menu['url']) ? 'active' : '';

                echo '<li class="nav-item ' . ($hasChildren ? 'has-treeview' : '') . '">';
                echo '<a href="' . $url . '" class="nav-link ' . $active . '">';
                echo '<i class="nav-icon ' . $icon . '"></i>';
                echo '<p>' . $title;
                if ($hasChildren) {
                  echo '<i class="right fas fa-angle-left"></i>';
                }
                echo '</p>';
                echo '</a>';

                if ($hasChildren) {
                  echo '<ul class="nav nav-treeview">';
                  renderMenuItems($menu['children']); // rekursif
                  echo '</ul>';
                }

                echo '</li>';
              }
            }
            renderMenuItems($menus);
            ?>
          </ul>


        </nav>
        <!-- /.sidebar-menu -->
      </div>
      <!-- /.sidebar -->
    </aside>

    <!-- Content Wrapper -->
    <div class="content-wrapper p-3">
      <?= $this->renderSection('content') ?>
    </div>

    <!-- Footer -->
    <footer class="main-footer text-center">
      <strong>© <?= date('Y') ?> Audit Terpadu.</strong> All rights reserved.
    </footer>

  </div>

  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <!-- Bootstrap 4 -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js"></script>
  <!-- AdminLTE -->
  <script src="https://cdn.jsdelivr.net/npm/admin-lte@3.1/dist/js/adminlte.min.js"></script>
  <!-- DataTables -->
  <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap4.min.js"></script>
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.js"></script>

  <?= $this->renderSection('scripts') ?>

  <script>
    // Example: Show SweetAlert2 for flash messages
    <?php if (session()->getFlashdata('success')): ?>
      Swal.fire({
        icon: 'success',
        title: 'Success',
        text: '<?= session()->getFlashdata('success') ?>',
        timer: 2500,
        timerProgressBar: true,
        showConfirmButton: false
      });
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: '<?= session()->getFlashdata('error') ?>',
        timer: 2500,
        timerProgressBar: true,
        showConfirmButton: false
      });
    <?php endif; ?>
  </script>
  <?php if (session()->getFlashdata('swal_error')): ?>
    <script>
      Swal.fire({
        icon: 'error',
        title: 'Oops!',
        text: '<?= session()->getFlashdata('swal_error') ?>',
        confirmButtonColor: '#d33'
      });
    </script>
  <?php endif; ?>


</body>

</html>