<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Edit Evaluasi Diri</h4>
        </div>
        <div class="card-body">

            <form action="<?= base_url('/evaluasi_diri/update/' . $item['id_evaluasi']) ?>" method="post">
                <?= csrf_field() ?>

                <!-- ID evaluasi TIDAK boleh diedit -->
                <input type="hidden" name="id_evaluasi" value="<?= $item['id_evaluasi'] ?>">

                <!-- PRODI -->
                <div class="mb-3">
                    <label class="form-label">Program Studi</label>
                    <select name="id_prodi" class="form-control" required>
                        <option value="">-- Pilih Prodi --</option>
                        <?php foreach ($prodi as $p): ?>
                            <option value="<?= $p['id_prodi'] ?>"
                                <?= old('id_prodi', $item['id_prodi']) == $p['id_prodi'] ? 'selected' : '' ?>>
                                <?= esc($p['nama_prodi']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- STANDAR -->
                <div class="mb-3">
                    <label class="form-label">Standar</label>
                    <select name="id_standar" class="form-control" required>
                        <option value="">-- Pilih Standar --</option>
                        <?php foreach ($standar as $s): ?>
                            <option value="<?= $s['id_standar'] ?>"
                                <?= old('id_standar', $item['id_standar']) == $s['id_standar'] ? 'selected' : '' ?>>
                                <?= esc($s['nama_standar']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- NILAI STANDAR -->
                <div class="mb-3">
                    <label class="form-label">Nilai Standar</label>
                    <input type="number" step="0.01" class="form-control"
                        name="nilai_standar"
                        value="<?= old('nilai_standar', $item['nilai_standar']) ?>"
                        required>
                </div>

                <!-- FAKTOR INTERNAL -->
                <div class="mb-3">
                    <label class="form-label">Faktor Internal</label>
                    <textarea class="form-control" name="faktor_internal" rows="3" required><?= old('faktor_internal', $item['faktor_internal']) ?></textarea>
                </div>

                <!-- FAKTOR EKSTERNAL -->
                <div class="mb-3">
                    <label class="form-label">Faktor Eksternal</label>
                    <textarea class="form-control" name="faktor_eksternal" rows="3" required><?= old('faktor_eksternal', $item['faktor_eksternal']) ?></textarea>
                </div>

                <!-- KESIMPULAN -->
                <div class="mb-3">
                    <label class="form-label">Kesimpulan</label>
                    <textarea class="form-control" name="kesimpulan" rows="3" required><?= old('kesimpulan', $item['kesimpulan']) ?></textarea>
                </div>

                <button type="submit" class="btn btn-warning">Update</button>
                <a href="<?= base_url('/evaluasi_diri') ?>" class="btn btn-secondary">Batal</a>

            </form>

        </div>
    </div>
</div>

<?= $this->endSection() ?>