<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Tambah Evaluasi Diri</h4>
        </div>

        <div class="card-body">
            <form action="<?= base_url('/evaluasi_diri/store') ?>" method="post">
                <?= csrf_field() ?>

                <!-- Standar -->
                <div class="mb-3">
                    <label class="form-label">Standar Akreditasi</label>
                    <select name="id_standar" class="form-control" required>
                        <option value="">-- Pilih Standar --</option>
                        <?php foreach ($standar as $s): ?>
                            <option value="<?= $s['id_standar'] ?>" <?= old('id_standar') == $s['id_standar'] ? 'selected' : '' ?>>
                                <?= $s['kode_standar'] ?> - <?= $s['nama_standar'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <!-- Prodi -->
                <div class="mb-3">
                    <label class="form-label">Program Studi</label>
                    <select name="id_prodi" class="form-control" required>
                        <option value="">-- Pilih Prodi --</option>
                        <?php foreach ($prodi as $p): ?>
                            <option value="<?= $p['id_prodi'] ?>" <?= old('id_prodi') == $p['id_prodi'] ? 'selected' : '' ?>>
                                <?= $p['nama_prodi'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <!-- Nilai -->
                <div class="mb-3">
                    <label class="form-label">Nilai Standar (0–100)</label>
                    <input type="number" name="nilai_standar" class="form-control"
                        min="0" max="100" value="<?= old('nilai_standar') ?>" required>
                </div>

                <!-- Faktor Internal -->
                <div class="mb-3">
                    <label class="form-label">Faktor Internal</label>
                    <textarea name="faktor_internal" class="form-control" rows="3"><?= old('faktor_internal') ?></textarea>
                </div>

                <!-- Faktor Eksternal -->
                <div class="mb-3">
                    <label class="form-label">Faktor Eksternal</label>
                    <textarea name="faktor_eksternal" class="form-control" rows="3"><?= old('faktor_eksternal') ?></textarea>
                </div>

                <!-- Kesimpulan -->
                <div class="mb-3">
                    <label class="form-label">Kesimpulan</label>
                    <textarea name="kesimpulan" class="form-control" rows="3"><?= old('kesimpulan') ?></textarea>
                </div>

                <button type="submit" class="btn btn-primary">Simpan</button>
                <a href="<?= base_url('/evaluasi_diri') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>