<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="card">
  <div class="card-header">
    <h5><?= $title ?></h5>
  </div>
  <div class="card-body">
    <?php if (session()->getFlashdata('success')): ?>
      <div class="alert alert-success"><?= session('success') ?></div>
    <?php endif; ?>

    <table class="table table-bordered">
      <tr>
        <th>Protocol</th>
        <td><?= esc($config['protocol']) ?></td>
      </tr>
      <tr>
        <th>SMTP Host</th>
        <td><?= esc($config['smtp_host']) ?></td>
      </tr>
      <tr>
        <th>SMTP User</th>
        <td><?= esc($config['smtp_user']) ?></td>
      </tr>
      <tr>
        <th>SMTP Port</th>
        <td><?= esc($config['smtp_port']) ?></td>
      </tr>
      <tr>
        <th>From Email</th>
        <td><?= esc($config['from_email']) ?></td>
      </tr>
      <tr>
        <th>From Name</th>
        <td><?= esc($config['from_name']) ?></td>
      </tr>
    </table>

    <div class="mt-3">
      <a href="<?= base_url('/email-config/edit/' . $config['id']) ?>" class="btn btn-primary">Edit Configuration</a>
      <button type="button" class="btn btn-info" onclick="testEmail()">Test Email</button>
    </div>

    <div id="testResult" class="mt-3" style="display: none;"></div>
  </div>
</div>

<script>
  function testEmail() {
    const button = event.target;
    const originalText = button.innerHTML;
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Testing...';
    button.disabled = true;

    fetch('<?= base_url('/email-config/test') ?>', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-Requested-With': 'XMLHttpRequest',
          'X-CSRF-TOKEN': '<?= csrf_hash() ?>'
        }
      })
      .then(response => response.json())
      .then(data => {
        const resultDiv = document.getElementById('testResult');
        resultDiv.style.display = 'block';
        if (data.success) {
          resultDiv.innerHTML = '<div class="alert alert-success">' + data.message + '</div>';
        } else {
          resultDiv.innerHTML = '<div class="alert alert-danger">' + data.message + '</div>';
        }
      })
      .catch(error => {
        document.getElementById('testResult').innerHTML = '<div class="alert alert-danger">Error: ' + error.message + '</div>';
        document.getElementById('testResult').style.display = 'block';
      })
      .finally(() => {
        button.innerHTML = originalText;
        button.disabled = false;
      });
  }
</script>

<?= $this->endSection() ?>