<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="card">
  <div class="card-header"><h5><?= $title ?></h5></div>
  <div class="card-body">

    <?php if (session('errors')): ?>
      <div class="alert alert-danger">
        <?php foreach (session('errors') as $error): ?>
          <div><?= esc($error) ?></div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>

    <form action="<?= base_url('/email-config/update/' . $config['id']) ?>" method="post">
      <?= csrf_field() ?>

      <div class="row">
        <div class="col-md-6">
          <div class="form-group mb-2">
            <label>Protocol</label>
            <input type="text" name="protocol" class="form-control" value="<?= esc($config['protocol']) ?>">
          </div>

          <div class="form-group mb-2">
            <label>SMTP Host</label>
            <input type="text" name="smtp_host" class="form-control" value="<?= esc($config['smtp_host']) ?>">
          </div>

          <div class="form-group mb-2">
            <label>SMTP User</label>
            <input type="text" name="smtp_user" class="form-control" value="<?= esc($config['smtp_user']) ?>">
          </div>

          <div class="form-group mb-2">
            <label>SMTP Pass</label>
            <input type="password" name="smtp_pass" class="form-control" value="<?= esc($config['smtp_pass']) ?>">
          </div>
        </div>

        <div class="col-md-6">
          <div class="form-group mb-2">
            <label>SMTP Port</label>
            <input type="text" name="smtp_port" class="form-control" value="<?= esc($config['smtp_port']) ?>">
          </div>

          <div class="form-group mb-2">
            <label>SMTP Crypto</label>
            <input type="text" name="smtp_crypto" class="form-control" value="<?= esc($config['smtp_crypto']) ?>">
          </div>

          <div class="form-group mb-2">
            <label>From Email</label>
            <input type="email" name="from_email" class="form-control" value="<?= esc($config['from_email']) ?>">
          </div>

          <div class="form-group mb-2">
            <label>From Name</label>
            <input type="text" name="from_name" class="form-control" value="<?= esc($config['from_name']) ?>">
          </div>
        </div>
      </div>

      <button type="submit" class="btn btn-success">Simpan</button>
      <a href="<?= base_url('/email-config') ?>" class="btn btn-secondary">Batal</a>
    </form>

  </div>
</div>

<?= $this->endSection() ?>
