<?= $this->extend('layout') ?>

<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Dashboard</h3>
                </div>
                <div class="card-body">
                    <p>Welcome to the Audit Terpadu Dashboard, <?= esc($user) ?>!</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Log Activities - Only for Super Admin -->
    <?php if (isset($isSuperAdmin) && $isSuperAdmin): ?>
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Recent Log Activities</h3>
                        <div class="card-tools">
                            <a href="<?= base_url('/log-aktivitas') ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-list"></i> View All Logs
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if (!empty($recentLogs)): ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Action</th>
                                            <th>User</th>
                                            <th>Timestamp</th>
                                            <th>IP Address</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($recentLogs as $log): ?>
                                            <tr>
                                                <td>
                                                    <span class="badge badge-info"><?= ucwords(str_replace('_', ' ', $log['aksi'])) ?></span>
                                                </td>
                                                <td>
                                                    <?= esc($log['username']) ?> (ID: <?= $log['user_id'] ?>)
                                                </td>
                                                <td>
                                                    <?= date('d M Y H:i', strtotime($log['created_at'])) ?>
                                                </td>
                                                <td>
                                                    <?= esc($log['ip_address']) ?: 'N/A' ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">No recent log activities found.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>