<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Tambah Daftar Tilik</h4>
        </div>

        <div class="card-body">
            <form action="<?= base_url('/daftar_tilik/store') ?>" method="post">
                <?= csrf_field() ?>

                <!-- STANDAR (FOREIGN KEY) -->
                <div class="mb-3">
                    <label class="form-label">Standar</label>
                    <select name="id_standar" class="form-control" required>
                        <option value="">-- Pilih Standar --</option>
                        <?php foreach ($standar as $s): ?>
                            <option value="<?= $s['id_standar'] ?>" <?= old('id_standar') == $s['id_standar'] ? 'selected' : '' ?>>
                                <?= $s['kode_standar'] ?> - <?= $s['nama_standar'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <!-- PERTANYAAN -->
                <div class="mb-3">
                    <label class="form-label">Pertanyaan</label>
                    <textarea name="pertanyaan" class="form-control" required><?= old('pertanyaan') ?></textarea>
                </div>

                <!-- JAWABAN -->
                <div class="mb-3">
                    <label class="form-label">Jawaban</label>
                    <textarea name="jawaban" class="form-control"><?= old('jawaban') ?></textarea>
                </div>

                <!-- LINK BUKTI -->
                <div class="mb-3">
                    <label class="form-label">Link Bukti</label>
                    <input type="text" name="link_bukti" class="form-control" value="<?= old('link_bukti') ?>">
                </div>

                <!-- HASIL OBSERVASI -->
                <div class="mb-3">
                    <label class="form-label">Hasil Observasi</label>
                    <textarea name="hasil_observasi" class="form-control"><?= old('hasil_observasi') ?></textarea>
                </div>

                <!-- HASIL TEMUAN (ENUM) -->
                <div class="mb-3">
                    <label class="form-label">Hasil Temuan</label>
                    <select name="hasil_temuan" class="form-control" required>
                        <option value="">-- Pilih Hasil --</option>
                        <option value="sesuai" <?= old('hasil_temuan') == 'sesuai' ? 'selected' : '' ?>>Sesuai</option>
                        <option value="tidak_sesuai_mayor" <?= old('hasil_temuan') == 'tidak_sesuai_mayor' ? 'selected' : '' ?>>Tidak Sesuai Mayor</option>
                        <option value="tidak_sesuai" <?= old('hasil_temuan') == 'tidak_sesuai' ? 'selected' : '' ?>>Tidak Sesuai</option>
                    </select>
                </div>

                <button type="submit" class="btn btn-primary">Simpan</button>
                <a href="<?= base_url('/daftar_tilik') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>