<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Tambah Capaian Kinerja Prodi</h4>
        </div>

        <div class="card-body">
            <form action="<?= base_url('/capaian_kinerja_prodi/store') ?>" method="post">
                <?= csrf_field() ?>

                <!-- STANDAR (DROPDOWN) -->
                <div class="mb-3">
                    <label class="form-label">Standar Akreditasi</label>
                    <select name="id_standar" class="form-control" required>
                        <option value="">-- Pilih Standar --</option>
                        <?php foreach ($standar as $s): ?>
                            <option value="<?= $s['id_standar'] ?>">
                                <?= $s['kode_standar'] ?> - <?= $s['nama_standar'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <!-- PRODI (DROPDOWN) -->
                <div class="mb-3">
                    <label class="form-label">Program Studi</label>
                    <select name="id_prodi" class="form-control" required>
                        <option value="">-- Pilih Prodi --</option>
                        <?php foreach ($prodi as $p): ?>
                            <option value="<?= $p['id_prodi'] ?>">
                                <?= $p['nama_prodi'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <!-- DESKRIPSI -->
                <div class="mb-3">
                    <label class="form-label">Deskripsi Capaian</label>
                    <textarea name="deskripsi_capaian"
                        class="form-control"
                        rows="3"
                        required><?= old('deskripsi_capaian') ?></textarea>
                </div>

                <!-- TAHUN -->
                <div class="mb-3">
                    <label class="form-label">Tahun</label>
                    <input type="number"
                        name="tahun"
                        class="form-control"
                        value="<?= old('tahun', date('Y')) ?>"
                        required>
                </div>

                <!-- BUTTON -->
                <div class="mt-3">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="<?= base_url('/capaian_kinerja_prodi') ?>" class="btn btn-secondary">
                        Batal
                    </a>
                </div>

            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>