<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">

        <div class="card-header">
            <h4>Detail Berkas</h4>
        </div>

        <div class="card-body">

            <table class="table table-bordered">
                <tbody>

                    <tr>
                        <th style="width: 200px;">ID Berkas</th>
                        <td><?= esc($item['id_file']) ?></td>
                    </tr>

                    <tr>
                        <th>ID File</th>
                        <td><?= esc($item['id_file']) ?></td>
                    </tr>

                    <tr>
                        <th>Nama Asli</th>
                        <td><?= esc($item['original_name']) ?></td>
                    </tr>

                    <tr>
                        <th>File Tersimpan</th>
                        <td>
                            <?php if (!empty($item['unique_name'])): ?>
                                <a
                                    href="<?= base_url('uploads/' . $item['unique_name']) ?>"
                                    target="_blank"
                                    class="btn btn-sm btn-primary">
                                    Lihat / Download File
                                </a>
                            <?php else: ?>
                                <span class="text-muted">Tidak ada file</span>
                            <?php endif; ?>
                        </td>
                    </tr>

                    <tr>
                        <th>Diupload Oleh</th>
                        <td><?= esc($item['id_user'] ?? '-') ?></td>
                    </tr>

                    <tr>
                        <th>Dibuat Pada</th>
                        <td><?= esc($item['created_at'] ?? '-') ?></td>
                    </tr>

                    <tr>
                        <th>Diperbarui Pada</th>
                        <td><?= esc($item['updated_at'] ?? '-') ?></td>
                    </tr>

                </tbody>
            </table>

            <a href="<?= base_url('/berkas') ?>" class="btn btn-secondary mt-3">Kembali</a>

        </div>

    </div>
</div>

<?= $this->endSection() ?>