<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">

        <div class="card-header">
            <h4>Edit Berkas</h4>
        </div>

        <div class="card-body">

            <!-- Notifikasi Error -->
            <?php if (session()->getFlashdata('error')): ?>
                <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
            <?php endif; ?>

            <form action="<?= base_url('/berkas/update/' . $item['id_file']) ?>" method="post" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <input type="hidden" name="_method" value="post">

                <!-- Tampilkan file lama -->
                <div class="mb-3">
                    <label class="form-label">File Saat Ini</label><br>

                    <?php if (!empty($item['unique_name'])): ?>
                        <a href="<?= base_url('uploads/' . $item['unique_name']) ?>" target="_blank">
                            <?= $item['original_name'] ?>
                        </a>
                    <?php else: ?>
                        <p class="text-muted">Tidak ada file</p>
                    <?php endif; ?>
                </div>

                <!-- Upload file baru -->
                <div class="mb-3">
                    <label for="file" class="form-label">Ganti File (Opsional)</label>
                    <input
                        type="file"
                        class="form-control"
                        id="file"
                        name="file"
                        accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                    <small class="text-muted">Kosongkan jika tidak ingin mengganti file.</small>
                </div>

                <button type="submit" class="btn btn-warning">Update</button>
                <a href="<?= base_url('/berkas') ?>" class="btn btn-secondary">Batal</a>

            </form>
        </div>

    </div>
</div>

<?= $this->endSection() ?>