<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Upload Berkas</h4>
        </div>

        <div class="card-body">

            <!-- Notifikasi Error -->
            <?php if (session()->getFlashdata('error')): ?>
                <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
            <?php endif; ?>

            <!-- Form Upload -->
            <form action="<?= base_url('/berkas/store') ?>" method="post" enctype="multipart/form-data">
                <?= csrf_field() ?>

                <div class="mb-3">
                    <label for="file" class="form-label">Pilih File</label>
                    <input
                        type="file"
                        class="form-control"
                        id="file"
                        name="file"
                        accept=".pdf,.doc,.docx,.jpg,.jpeg,.png"
                        required>
                    <small class="text-muted">Format: PDF, DOC, DOCX, JPG, PNG</small>
                </div>

                <button type="submit" class="btn btn-primary">Upload</button>
                <a href="<?= base_url('/berkas') ?>" class="btn btn-secondary">Batal</a>
            </form>

        </div>
    </div>
</div>

<?= $this->endSection() ?>