<?= $this->extend('layout') ?>
<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="card shadow">
        <div class="card-header">
            <h4>Edit Auditor</h4>
        </div>
        <div class="card-body">
            <form action="<?= base_url('/auditor/update/' . $item['id_auditor']) ?>" method="post">
                <?= csrf_field() ?>
                <input type="hidden" name="_method" value="post">

                <div class="mb-3">
                    <label class="form-label">Pilih Dosen</label>
                    <select name="id_dosen" class="form-control" required>
                        <?php foreach ($dosen as $d): ?>
                            <option value="<?= $d['id_dosen'] ?>"
                                <?= $item['id_dosen'] == $d['id_dosen'] ? 'selected' : '' ?>>
                                <?= $d['nama_lengkap'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">Status Aktif</label>
                    <select name="status_aktif" class="form-control" required>
                        <option value="aktif" <?= $item['status_aktif'] == 'aktif' ? 'selected' : '' ?>>Aktif</option>
                        <option value="nonaktif" <?= $item['status_aktif'] == 'nonaktif' ? 'selected' : '' ?>>Nonaktif</option>
                    </select>
                </div>

                <button type="submit" class="btn btn-warning">Update</button>
                <a href="<?= base_url('/auditor') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>
<?= $this->endSection() ?>