<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
    protected $table = 'users';
    protected $primaryKey = 'id';

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $allowedFields = [
        'name',
        'email',
        'password',
        'role_id',
        'permissions',
        'reset_token',
        'reset_expires_at',
    ];

    protected $returnType = 'array';

    // Convert permissions from JSON string to array after fetch
    protected function afterFind(array $data)
    {
        if (isset($data['data'])) {
            if (isset($data['data'][0])) {
                // Multiple rows
                foreach ($data['data'] as &$row) {
                    $row['permissions'] = json_decode($row['permissions'], true);
                }
            } else {
                // Single row
                $data['data']['permissions'] = json_decode($data['data']['permissions'], true);
            }
        }
        return $data;
    }

    // Convert permissions array to JSON string before insert/update
    protected function beforeInsert(array $data)
    {
        return $this->encodePermissions($data);
    }

    protected function beforeUpdate(array $data)
    {
        return $this->encodePermissions($data);
    }

    private function encodePermissions(array $data)
    {
        if (isset($data['data']['permissions']) && is_array($data['data']['permissions'])) {
            $data['data']['permissions'] = json_encode($data['data']['permissions']);
        }
        return $data;
    }
    
}
