<?php

namespace App\Models;

use CodeIgniter\Model;

class RoleModel extends Model
{
    protected $table = 'roles';
    protected $primaryKey = 'id';
    protected $allowedFields = ['name', 'description', 'permissions'];
    protected $useTimestamps = true;
    protected $returnType = 'array';

    /**
     * Convert JSON permissions → array after find
     */
    protected function afterFind(array $data): array
    {
        if (isset($data['data'])) {
            // Hasil findAll() atau find()
            if (isset($data['data']['permissions']) && is_string($data['data']['permissions'])) {
                $data['data']['permissions'] = json_decode($data['data']['permissions'], true) ?? [];
            } elseif (is_array($data['data'])) {
                foreach ($data['data'] as &$row) {
                    if (isset($row['permissions']) && is_string($row['permissions'])) {
                        $row['permissions'] = json_decode($row['permissions'], true) ?? [];
                    }
                }
            }
        }
        return $data;
    }

    /**
     * Encode permissions array → JSON before insert
     */
    protected function beforeInsert(array $data): array
    {
        if (isset($data['data']['permissions']) && is_array($data['data']['permissions'])) {
            $data['data']['permissions'] = json_encode($data['data']['permissions']);
        } elseif (isset($data['permissions']) && is_array($data['permissions'])) {
            // Antisipasi jika dikirim tanpa key "data"
            $data['permissions'] = json_encode($data['permissions']);
        }
        return $data;
    }

    /**
     * Encode permissions array → JSON before update
     */
    protected function beforeUpdate(array $data): array
    {
        if (isset($data['data']['permissions']) && is_array($data['data']['permissions'])) {
            $data['data']['permissions'] = json_encode($data['data']['permissions']);
        } elseif (isset($data['permissions']) && is_array($data['permissions'])) {
            $data['permissions'] = json_encode($data['permissions']);
        }
        return $data;
    }

    protected $validationRules = [
        'name' => 'required|min_length[3]',
        'description' => 'permit_empty',
        'permissions' => 'permit_empty'
    ];

    protected $validationMessages = [
        'name' => [
            'required' => 'Nama role harus diisi',
            'min_length' => 'Nama role minimal 3 karakter'
        ]
    ];
}
