<?php

namespace App\Models;

use CodeIgniter\Model;

class MenuModel extends Model
{
    protected $table = 'menus';
    protected $primaryKey = 'id';

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $allowedFields = [
        'title',
        'url',
        'icon',
        'parent_id',
        'permission',
        'sort_order',
    ];

    protected $returnType = 'array';

    /**
     * Get menus that match any of the given permissions
     */
    public function getMenusByPermissions(array $userPermissions, $onlyParent = false)
    {
        $builder = $this->builder();

        if ($onlyParent) {
            $builder->where('parent_id', null);
        }

        $builder->groupStart();
        $builder->where('permission', null); // Menampilkan menu tanpa permission juga
        if (!empty($userPermissions)) {
            $builder->orWhereIn('permission', $userPermissions);
        }
        $builder->groupEnd();

        return $builder->orderBy('sort_order', 'ASC')->get()->getResultArray();
    }

    /**
     * Get child menus by parent ID and user permissions
     */
    public function getChildMenus(int $parentId, array $userPermissions)
    {
        return $this->where('parent_id', $parentId)
            ->groupStart()
                ->where('permission', null)
                ->orWhereIn('permission', $userPermissions)
            ->groupEnd()
            ->orderBy('sort_order', 'ASC')
            ->findAll();
    }
}
