<?php

namespace App\Models;

use CodeIgniter\Model;

class LogAktivitasModel extends Model
{
    protected $table = 'log_aktivitas';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'aksi',
        'keterangan',
        'user_id',
        'username',
        'ip_address',
        'user_agent',
        'url',
        'created_at'
    ];
    protected $useTimestamps = false;
    protected $createdField = 'created_at';
    protected $updatedField = null;

    protected $validationRules = [
        'aksi' => 'required|max_length[255]',
        'user_id' => 'required|integer',
        'username' => 'required|max_length[255]',
        'keterangan'  => 'permit_empty|string',
        'ip_address' => 'max_length[45]',
        'user_agent' => 'max_length[500]',
        'url' => 'max_length[500]',
    ];

    protected $validationMessages = [
        'aksi' => [
            'required' => 'Action is required',
            'max_length' => 'Action cannot exceed 255 characters'
        ],
        'user_id' => [
            'required' => 'User ID is required',
            'integer' => 'User ID must be an integer'
        ],
        'username' => [
            'required' => 'Username is required',
            'max_length' => 'Username cannot exceed 255 characters'
        ],
        'ip_address' => [
            'max_length' => 'IP address cannot exceed 45 characters'
        ],
        'user_agent' => [
            'max_length' => 'User agent cannot exceed 500 characters'
        ],
        'url' => [
            'max_length' => 'URL cannot exceed 500 characters'
        ],
    ];
    public function log($aksi, $userId, $username, $url, $keterangan = null)
    {
        return $this->insert([
            'aksi'        => $aksi,
            'keterangan'  => $keterangan,
            'user_id'     => $userId,
            'username'    => $username,
            'ip_address'  => service('request')->getIPAddress(),
            'user_agent'  => service('request')->getUserAgent()->getAgentString(),
            'url'         => $url,
            'created_at'  => date('Y-m-d H:i:s'),
        ]);
    }
    // Method to get logs with pagination
    public function getLogs($limit = 20, $offset = 0)
    {
        return $this->orderBy('created_at', 'DESC')
            ->findAll($limit, $offset);
    }

    // Method to get logs by user
    public function getLogsByUser($userId, $limit = 20, $offset = 0)
    {
        return $this->where('user_id', $userId)
            ->orderBy('created_at', 'DESC')
            ->findAll($limit, $offset);
    }

    // Method to get logs by action type
    public function getLogsByAction($action, $limit = 20, $offset = 0)
    {
        return $this->where('aksi', $action)
            ->orderBy('created_at', 'DESC')
            ->findAll($limit, $offset);
    }

    // Method to get recent logs for dashboard
    public function getRecentLogs($limit = 10)
    {
        return $this->orderBy('created_at', 'DESC')
            ->findAll($limit);
    }

    // Method to count total logs
    public function countLogs()
    {
        return $this->countAll();
    }
}
