<?php

namespace App\Models;

use CodeIgniter\Model;

class EmailConfigModel extends Model
{
    protected $table = 'email_configs';
    protected $primaryKey = 'id';

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $allowedFields = [
        'protocol',
        'smtp_host',
        'smtp_user',
        'smtp_pass',
        'smtp_port',
        'smtp_crypto',
        'from_email',
        'from_name',
        'is_active',
    ];

    protected $returnType = 'array';

    // Get active email configuration
    public function getActiveConfig()
    {
        return $this->where('is_active', 1)->first();
    }

    // Set active configuration (deactivate others)
    public function setActive($id)
    {
        $this->updateAll(['is_active' => 0]);
        return $this->update($id, ['is_active' => 1]);
    }

    // Update all records with same field
    private function updateAll(array $data)
    {
        return $this->db->table($this->table)->update($data);
    }
}
