<?php

namespace App\Libraries;

use CodeIgniter\Database\ConnectionInterface;

class LogAktivitas
{
    protected $db;

    public function __construct()
    {
        $this->db = \Config\Database::connect();
    }

    /**
     * Log an activity to the log_aktivitas table.
     *
     * @param string $aksi The action performed (e.g., 'login', 'create_user', 'update_role')
     * @param int|null $user_id The ID of the user performing the action
     * @param string|null $username The username of the user
     * @param string|null $url The URL where the action occurred
     * @return bool True on success, false on failure
     */
    public function log(string $aksi, ?int $user_id = null, ?string $username = null, ?string $url = null, ?string $keterangan = null): bool
    {
        $data = [
            'user_id'    => $user_id,
            'username'   => $username,
            'aksi'       => $aksi,
            'keterangan' => $keterangan,
            'ip_address' => $this->getClientIP(),
            'user_agent' => $this->getUserAgent(),
            'url'        => $url,
            'created_at' => date('Y-m-d H:i:s'),
        ];

        try {
            $this->db->table('log_aktivitas')->insert($data);
            return true;
        } catch (\Exception $e) {
            // Log error if needed, but don't throw to avoid breaking app
            log_message('error', 'Failed to log activity: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Get the client's IP address.
     *
     * @return string
     */
    private function getClientIP(): string
    {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            return $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            return $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            return $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
        }
    }

    /**
     * Get the user agent string.
     *
     * @return string|null
     */
    private function getUserAgent(): ?string
    {
        return $_SERVER['HTTP_USER_AGENT'] ?? null;
    }
}
