<?php

use App\Models\UserModel;
use App\Models\RoleModel;

if (!function_exists('get_user_permissions')) {
    /**
     * Retrieve array of permissions of logged-in user based on their role.
     *
     * @return array
     */
    function get_user_permissions(): array
    {
        $session = session();
        if (!$session->get('isLoggedIn')) {
            return [];
        }

        // Cek apakah sudah tersimpan di session
        if ($session->has('user_permissions')) {
            return $session->get('user_permissions');
        }

        $userModel = new \App\Models\UserModel();
        $user = $userModel->find($session->get('id'));

        if (!$user || empty($user['role_id'])) {
            return [];
        }

        $roleModel = new \App\Models\RoleModel();
        $role = $roleModel->find($user['role_id']);

        if (!$role || empty($role['permissions'])) {
            return [];
        }

        $permissions = is_array($role['permissions']) ? $role['permissions'] : [];

        // Simpan ke session agar tidak ambil DB lagi
        $session->set('user_permissions', $permissions);

        return $permissions;
    }
}

if (!function_exists('get_all_permissions')) {
    /**
     * Get all available permissions from menus, CRUD operations, and dynamically generated tables.
     *
     * @return array
     */
    function get_all_permissions(): array
    {
        $menuModel = new \App\Models\MenuModel();
        $menus = $menuModel->findAll();

        $permissions = [];

        // Menu access permissions
        foreach ($menus as $menu) {
            if (!empty($menu['permission'])) {
                $permissions[] = $menu['permission'];
            }
        }

        // CRUD operations for dynamic tables (will be checked at runtime)
        $crudOperations = ['create', 'read', 'update', 'delete', 'print', 'export', 'import'];

        // Add specific role permissions
        $rolePermissions = [
            'user_view',
            'user_create',
            'user_edit',
            'user_delete',
            'menu_view',
            'menu_create',
            'menu_edit',
            'menu_delete',
            'roles_view',
            'roles_create',
            'roles_edit',
            'roles_delete',
            'codegen_view',
            'codegen_create'
        ];

        // Get permissions from dynamically generated tables
        $db = \Config\Database::connect();
        $tables = $db->listTables();

        $dynamicPermissions = [];
        foreach ($tables as $table) {
            // Skip system tables
            if (in_array($table, ['migrations', 'menus', 'roles', 'users'])) {
                continue;
            }

            $tablePermission = strtolower($table) . '_';
            $dynamicPermissions[] = $tablePermission . 'view';
            $dynamicPermissions[] = $tablePermission . 'create';
            $dynamicPermissions[] = $tablePermission . 'edit';
            $dynamicPermissions[] = $tablePermission . 'delete';
        }

        return array_unique(array_merge($permissions, $crudOperations, $rolePermissions, $dynamicPermissions));
    }
}
