<?php
namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class AuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $session = session();
        if (!$session->get('isLoggedIn')) {
            return redirect()->to('/login');
        }

        // Optional: here you can check permissions for specific routes
        // e.g. check if user role or permissions allow access
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // No action after request
    }
}
