<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class InitialDataSeeder extends Seeder
{
    public function run()
    {
        $db      = \Config\Database::connect();

        // Insert sample users
        $passwordAdmin = password_hash('Admin123!', PASSWORD_DEFAULT);
        $passwordUser = password_hash('User1234!', PASSWORD_DEFAULT);

        $db->table('roles')->insertBatch([
            [
                'id'    => '1',
                'name'  => 'superadmin',
                'description' => 'level yang dapat mengakses semua menu',
                'permissions' => json_encode([
                    'user_view',
                    'user_create',
                    'user_edit',
                    'user_delete',
                    'menu_view',
                    'menu_create',
                    'menu_edit',
                    'menu_delete',
                    'roles_view',
                    'roles_create',
                    'roles_edit',
                    'roles_delete',
                    'codegen_view',
                    'codegen_create',
                    'create',
                    'read',
                    'update',
                    'delete',
                    'print',
                    'export',
                    'import'
                ])
            ],
            [
                'id'    => '2',
                'name'  => 'admin',
                'description' => 'level yang dapat mengakses sebagian menu',
                'permissions' => json_encode([
                    'user_view',
                    'user_create',
                    'user_edit',
                    'menu_view',
                    'menu_create',
                    'menu_edit',
                    'roles_view',
                    'create',
                    'read',
                    'update',
                    'print',
                    'export'
                ])
            ]
        ]);

        $db->table('users')->insertBatch([
            [
                'name'        => 'Admin User',
                'email'       => 'admin@example.com',
                'password'    => $passwordAdmin,
                'role_id'     => '1',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'name'        => 'Regular User',
                'email'       => 'user@example.com',
                'password'    => $passwordUser,
                'role_id'     => '2',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
        ]);

        // Insert sample menus
        $db->table('menus')->insertBatch([
            [
                'title'      => 'Dashboard',
                'url'        => '/dashboard',
                'icon'       => 'fas fa-tachometer-alt',
                'parent_id'  => null,
                'permission' => null,
                'sort_order' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'title'      => 'User Management',
                'url'        => '/users',
                'icon'       => 'fas fa-users',
                'parent_id'  => null,
                'permission' => 'user_view',
                'sort_order' => 2,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'title'      => 'Create User',
                'url'        => '/users/create',
                'icon'       => 'fas fa-user-plus',
                'parent_id'  => 2,  // Assuming User Management has ID 2 after insert
                'permission' => 'user_create',
                'sort_order' => 3,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'title'      => 'Menu Management',
                'url'        => '/menus',
                'icon'       => 'fas fa-list',
                'parent_id'  => null,
                'permission' => 'menu_view',
                'sort_order' => 4,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'title'      => 'Create Menu',
                'url'        => '/menus/create',
                'icon'       => 'fas fa-plus-circle',
                'parent_id'  => 4,
                'permission' => 'menu_create',
                'sort_order' => 5,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
        ]);
    }
}
