<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateEmailConfigsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'protocol' => [
                'type' => 'VARCHAR',
                'constraint' => '20',
                'default' => 'smtp',
            ],
            'smtp_host' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],
            'smtp_user' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'null' => true,
            ],
            'smtp_pass' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'null' => true,
            ],
            'smtp_port' => [
                'type' => 'INT',
                'default' => 587,
            ],
            'smtp_crypto' => [
                'type' => 'VARCHAR',
                'constraint' => '10',
                'default' => 'tls',
                'null' => true,
            ],
            'from_email' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],
            'from_name' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default' => 'AUDIT TERPADU',
            ],
            'is_active' => [
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 0,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('email_configs');
    }

    public function down()
    {
        $this->forge->dropTable('email_configs');
    }
}
