<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterProdiTable extends Migration
{
    public function up()
    {
        // Add the id_user column
        $this->forge->addColumn('prodi', [
            'id_user' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],
        ]);

        // Add the foreign key to users table
        $this->forge->addForeignKey('id_user', 'users', 'id', 'SET NULL', 'CASCADE');
    }

    public function down()
    {
        // Drop the foreign key
        $this->forge->dropForeignKey('prodi', 'prodi_id_user_foreign');

        // Drop the id_user column
        $this->forge->dropColumn('prodi', 'id_user');
    }
}
