<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterFakultasTable extends Migration
{
    public function up()
    {
        // Drop the existing foreign key
        $this->forge->dropForeignKey('fakultas', 'fakultas_id_dosen_foreign');

        // Rename the column from id_dosen to id_user
        $this->db->query('ALTER TABLE fakultas CHANGE id_dosen id_user INT(11) UNSIGNED');

        // Add the new foreign key to users table
        $this->forge->addForeignKey('id_user', 'users', 'id', 'SET NULL', 'CASCADE');
    }

    public function down()
    {
        // Drop the new foreign key
        $this->forge->dropForeignKey('fakultas', 'fakultas_id_user_foreign');

        // Rename back to id_dosen
        $this->db->query('ALTER TABLE fakultas CHANGE id_user id_dosen INT(11) UNSIGNED');

        // Add back the old foreign key to dosen table
        $this->forge->addForeignKey('id_dosen', 'dosen', 'id_dosen', 'CASCADE', 'CASCADE');
    }
}
